<?php

namespace App\Http\Controllers;

use App\Models\Equipo;
use App\Models\Mensaje;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;

class MensajeController extends Controller{

    public function index(){
        $data = Mensaje::all();
        return response()->json($data, 200);
    }
    public function store(Request $request) {
        $foto = '';
        if($request->foto_file != null) {
            $fondoName = 'mensaje_image_' . time() . '.' . $request->foto_file->extension();
            $request->foto_file->move(public_path('images'), $fondoName);
            $foto = 'images/' . $fondoName;
        }
        $audio = '';
        if($request->audio_file != null) {
            $audioName = 'mensaje_audio_' . time() . '.' . $request->audio_file->extension();
            $request->audio_file->move(public_path('audios'), $audioName);
            $audio = 'audios/' . $audioName;
        }
        $mess = new Mensaje();
        $mess->mensaje_nombre = $request->mensaje_nombre;
        $mess->mensaje_mensaje = $request->mensaje_mensaje;
        $mess->mensaje_mensaje = $request->mensaje_mensaje;
        $mess->mensaje_foto = $foto;
        $mess->mensaje_audio = $audio;
        $mess->usuario_id = $request->usuario_id;
        $mess->save();
        return response()->json($mess, 200);
    }

    public function destroy($id) {
        $data = Mensaje::find($id);
        if($data['mensaje_foto'] != '') {
            if(File::exists($data['mensaje_foto'])) {
                File::delete($data['mensaje_foto']);
            }
        }
        if($data['mensaje_audio'] != '') {
            if(File::exists($data['mensaje_audio'])) {
                File::delete($data['mensaje_audio']);
            }
        }
        $data->delete();
        return response()->json(['success'=>true], 200);
    }
    public function show($id){
        $data = Mensaje::find($id);
        return response()->json($data, 200);
    }
    public function mostrarMensajeUser($id){
        $data = Mensaje::where('usuario_id','=',$id)->get();
        return response()->json($data, 200);
    }
}
