<?php
namespace App\Http\Controllers;

use App\Models\Multiradio;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;

class MultiradioController extends Controller{

    public function index(){
        $data = Multiradio::all();
        return response()->json($data, 200);
    }
    public function store(Request $request) {
        $foto = '';
        if($request->foto_file != null) {
            $fondoName = time() . '_multiradio.' . $request->foto_file->extension();
            $request->foto_file->move(public_path('images'), $fondoName);
            $foto = 'images/' . $fondoName;
        }
        $multi = new Multiradio();
        $multi->multiradio_nombre = $request->multiradio_nombre;
        $multi->multiradio_descripcion = $request->multiradio_descripcion;
        $multi->multiradio_imagen = $foto;
        $multi->multiradio_url = $request->multiradio_url;
        $multi->usuario_id = $request->usuario_id;
        $multi->save();
        return response()->json($multi, 200);
    }
    public function updateMulti(Request $request) {
        $data = Multiradio::find($request->id);
        $foto = '';
        if($request->multiradio_imagen == '') {
            if ($request->foto_file != null) {
                $fondoName = time() . '.' . $request->foto_file->extension();
                $request->foto_file->move(public_path('images'), $fondoName);
                $foto = 'images/' . $fondoName;
            }
            if($data['multiradio_imagen']!='') {
                if(File::exists($data['multiradio_imagen'])) {
                    File::delete($data['multiradio_imagen']);
                }
            }
        } else {
            $foto = $request->multiradio_imagen;
        }

        $multi = [
            'multiradio_nombre' => $request['multiradio_nombre'],
            'multiradio_imagen'=> $foto,
            'multiradio_descripcion' => $request['multiradio_descripcion'],
            'multiradio_url' => $request['multiradio_url'],
            'usuario_id' => $request['usuario_id']
        ];
        $data->update($multi);
        return response()->json($data, 201);
    }
    public function destroy($id) {
        $data = Multiradio::find($id);
        if($data['multiradio_imagen'] != '') {
            if(File::exists($data['multiradio_imagen'])) {
                File::delete($data['multiradio_imagen']);
            }
        }
        $data->delete();
        return response()->json(['success'=>true], 200);
    }
    public function show($id){
        $data = Multiradio::find($id);
        return response()->json($data, 200);
    }
    public function mostrarMultiradioUser($id){
        $data = Multiradio::where('usuario_id','=',$id)->get();
        return response()->json($data, 200);
    }
}
