<?php
namespace App\Http\Controllers;

use App\Models\Multitv;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;

class MultitvController extends Controller{

    public function index(){
        $data = Multitv::all();
        return response()->json($data, 200);
    }
    public function store(Request $request) {
        $foto = '';
        if($request->foto_file != null) {
            $fondoName = time() . '_multitv.' . $request->foto_file->extension();
            $request->foto_file->move(public_path('images'), $fondoName);
            $foto = 'images/' . $fondoName;
        }
        $multi = new Multitv();
        $multi->multitv_nombre = $request->multitv_nombre;
        $multi->multitv_descripcion = $request->multitv_descripcion;
        $multi->multitv_imagen = $foto;
        $multi->multitv_url = $request->multitv_url;
        $multi->usuario_id = $request->usuario_id;
        $multi->save();
        return response()->json($multi, 200);
    }
    public function updateMultitv(Request $request) {
        $data = Multitv::find($request->id);
        $foto = '';
        if($request->multitv_imagen == '') {
            if ($request->foto_file != null) {
                $fondoName = time() . '.' . $request->foto_file->extension();
                $request->foto_file->move(public_path('images'), $fondoName);
                $foto = 'images/' . $fondoName;
            }
            if($data['multitv_imagen']!='') {
                if(File::exists($data['multitv_imagen'])) {
                    File::delete($data['multitv_imagen']);
                }
            }
        } else {
            $foto = $request->multitv_imagen;
        }

        $multi = [
            'multitv_nombre' => $request['multitv_nombre'],
            'multitv_imagen'=> $foto,
            'multitv_descripcion' => $request['multitv_descripcion'],
            'multitv_url' => $request['multitv_url'],
            'usuario_id' => $request['usuario_id']
        ];
        $data->update($multi);
        return response()->json($data, 201);
    }
    public function destroy($id) {
        $data = Multitv::find($id);
        if($data['multitv_imagen'] != '') {
            if(File::exists($data['multitv_imagen'])) {
                File::delete($data['multitv_imagen']);
            }
        }
        $data->delete();
        return response()->json(['success'=>true], 200);
    }
    public function show($id){
        $data = Multitv::find($id);
        return response()->json($data, 200);
    }
    public function mostrarMultiTvUser($id){
        $data = Multitv::where('usuario_id','=',$id)->get();
        return response()->json($data, 200);
    }
}
