<?php

namespace App\Http\Controllers;

use App\Models\Programa;
use App\Models\Radio;
use App\Models\Usuario;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;

class ProgramaController extends Controller{

    public function index(){
        $data = Programa::all();
        return response()->json($data, 200);
    }
    public function store(Request $request) {
        $foto = '';
        if($request->foto_file != null) {
            $fondoName = time() . '.' . $request->foto_file->extension();
            $request->foto_file->move(public_path('images'), $fondoName);
            $foto = 'images/' . $fondoName;
        }
        $prog = new Programa();
        $prog->prog_nombre = '';
        $prog->prog_foto = $foto;
        $prog->prog_horario_lu = $request->prog_horario_lu;
        $prog->prog_horario_ma = $request->prog_horario_ma;
        $prog->prog_horario_mi = $request->prog_horario_mi;
        $prog->prog_horario_ju = $request->prog_horario_ju;
        $prog->prog_horario_vi = $request->prog_horario_vi;
        $prog->prog_horario_sa = $request->prog_horario_sa;
        $prog->prog_horario_do = $request->prog_horario_do;
        $prog->prog_lu = $request->prog_lu;
        $prog->prog_ma = $request->prog_ma;
        $prog->prog_mi = $request->prog_mi;
        $prog->prog_ju = $request->prog_ju;
        $prog->prog_vi = $request->prog_vi;
        $prog->prog_sa = $request->prog_sa;
        $prog->prog_do = $request->prog_do;
        $prog->prog_titulo = $request->prog_titulo;
        $prog->prog_descripcion = $request->prog_descripcion;
        $prog->usuario_id = $request->usuario_id;
        $prog->save();
        return response()->json($prog, 200);
    }
    public function updateProg(Request $request) {
        $data = Programa::find($request->id);
        $foto = '';
        if($request->prog_foto == '') {
            if ($request->foto_file != null) {
                $fondoName = time() . '.' . $request->foto_file->extension();
                $request->foto_file->move(public_path('images'), $fondoName);
                $foto = 'images/' . $fondoName;
            }
            if($data['prog_foto']!='') {
                if(File::exists($data['prog_foto'])) {
                    File::delete($data['prog_foto']);
                }
            }
        } else {
            $foto = $request->prog_foto;
        }

        $prog = [
            'prog_nombre'=>'',
            'prog_foto'=> $foto,
            'prog_horario_lu' => $request['prog_horario_lu'],
            'prog_horario_ma' => $request['prog_horario_ma'],
            'prog_horario_mi' => $request['prog_horario_mi'],
            'prog_horario_ju' => $request['prog_horario_ju'],
            'prog_horario_vi' => $request['prog_horario_vi'],
            'prog_horario_sa' => $request['prog_horario_sa'],
            'prog_horario_do' => $request['prog_horario_do'],
            'prog_lu' => $request['prog_lu'],
            'prog_ma' => $request['prog_ma'],
            'prog_mi' => $request['prog_mi'],
            'prog_ju' => $request['prog_ju'],
            'prog_vi' => $request['prog_vi'],
            'prog_sa' => $request['prog_sa'],
            'prog_do' => $request['prog_do'],
            'prog_titulo' => $request['prog_titulo'],
            'prog_descripcion' => $request['prog_descripcion'],
            'usuario_id' => $request['usuario_id']
        ];
        $data->update($prog);
        return response()->json($data, 201);
    }
    public function destroy($id) {
        $data = Programa::find($id);
        if($data['prog_foto'] != '') {
            if(File::exists($data['prog_foto'])) {
                File::delete($data['prog_foto']);
            }
        }
        $data->delete();
        return response()->json(['success'=>true], 200);
    }
    public function show($id){
        $data = Programa::find($id);
        return response()->json($data, 200);
    }
    public function mostrarProgramaUser($id){
        $data = Programa::where('usuario_id','=',$id)->get();
        return response()->json($data, 200);
    }
}
