<?php
namespace App\Http\Controllers;

use App\Models\Tipomusica;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;

class TipomusicaController extends Controller{

    public function index(){
        $data = Tipomusica::all();
        return response()->json($data, 200);
    }
    public function store(Request $request) {
        $foto = '';
        if($request->foto_file != null) {
            $fondoName = time() . '_tipomusica.' . $request->foto_file->extension();
            $request->foto_file->move(public_path('images'), $fondoName);
            $foto = 'images/' . $fondoName;
        }
        $tipomusica = new Tipomusica();
        $tipomusica->tipomusica_titulo = $request->tipomusica_titulo;
        $tipomusica->tipomusica_desc = $request->tipomusica_desc;
        $tipomusica->tipomusica_imagen = $foto;
        $tipomusica->usuario_id = $request->usuario_id;
        $tipomusica->save();
        return response()->json($tipomusica, 200);
    }
    public function updateTipomusica(Request $request) {
        $data = Tipomusica::find($request->id);
        $foto = '';
        if($request->tipomusica_imagen == '') {
            if ($request->foto_file != null) {
                $fondoName = time() . '_tipomusica.' . $request->foto_file->extension();
                $request->foto_file->move(public_path('images'), $fondoName);
                $foto = 'images/' . $fondoName;
            }
            if($data['tipomusica_imagen']!='') {
                if(File::exists($data['tipomusica_imagen'])) {
                    File::delete($data['tipomusica_imagen']);
                }
            }
        } else {
            $foto = $request->tipomusica_imagen;
        }

        $tipomusica = [
            'tipomusica_titulo' => $request['tipomusica_titulo'],
            'tipomusica_imagen'=> $foto,
            'tipomusica_desc' => $request['tipomusica_desc'],
            'usuario_id' => $request['usuario_id']
        ];
        $data->update($tipomusica);
        return response()->json($data, 201);
    }
    public function destroy($id) {
        $data = Tipomusica::find($id);
        if($data['tipomusica_imagen'] != '') {
            if(File::exists($data['tipomusica_imagen'])) {
                File::delete($data['tipomusica_imagen']);
            }
        }
        $data->delete();
        return response()->json(['success'=>true], 200);
    }
    public function show($id){
        $data = Tipomusica::find($id);
        return response()->json($data, 200);
    }
    public function mostrarTipomusicaUser($id){
        $data = Tipomusica::where('usuario_id','=',$id)->get();
        return response()->json($data, 200);
    }
}
