<?php

namespace App\Http\Controllers;

use App\Models\Video;
use Illuminate\Http\Request;

class VideoController extends Controller{

    public function index() {
        $data = Video::all();
        return response()->json($data, 200);
    }
    public function store(Request $request) {
        $data = Video::create($request->all());
        return response()->json($data, 200);
    }
    public function update(Request $request, $id) {
        $data = Video::find($id);
        $data->update($request->all());
        return response()->json($data, 201);
    }
    public function destroy($id) {
        $data = Video::find($id);
        $data->delete();
        return response()->json(['success'=>true], 200);
    }
    public function show($id){
        $data = Video::find($id);
        return response()->json($data, 200);
    }
    public function mostrarVideoUser($id) {
        $data = Video::where('usuario_id','=',$id)->get();
        return response()->json($data, 200);
    }
}
