<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;
use App\Models\Usuario;

class UsuarioFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Usuario::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'usuario_nombre' => $this->faker->word,
            'usuario_foto' => $this->faker->word,
            'usuario_user' => $this->faker->word,
            'password' => $this->faker->word,
            'usuario_tipo' => $this->faker->randomElement(["Admin","Radio"]),
        ];
    }
}
