<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateRadiosTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::disableForeignKeyConstraints();

        Schema::create('radios', function (Blueprint $table) {
            $table->id();
            $table->string('radio_nombre')->nullable();
            $table->string('radio_url')->nullable();
            $table->string('radio_video')->nullable();
            $table->string('radio_whatsapp')->nullable();
            $table->string('radio_facebook_url')->nullable();
            $table->string('radio_facebook_id')->nullable();
            $table->string('radio_web')->nullable();
            $table->string('radio_youtube')->nullable();
            $table->string('radio_instagram')->nullable();
            $table->string('radio_fondo')->nullable();
            $table->string('radio_menu_nicio')->nullable();
            $table->string('radio_menu_noticias')->nullable();
            $table->string('radio_menu_programas')->nullable();
            $table->string('radio_menu_mensajes')->nullable();
            $table->foreignId('usuario_id')->constrained()->cascadeOnDelete()->cascadeOnUpdate();
            $table->timestamps();
        });

        Schema::enableForeignKeyConstraints();
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('radios');
    }
}
