<?php

use App\Http\Controllers\MultiradioController;
use App\Http\Controllers\ProgramaController;
use App\Http\Controllers\RadioController;
use App\Http\Controllers\SlideController;
use App\Http\Controllers\UsuarioController;
use App\Http\Controllers\VideoController;
use App\Http\Controllers\PodcastController;
use App\Http\Controllers\EquipoController;
use App\Http\Controllers\MensajeController;
use App\Http\Controllers\GeovallaController;
use App\Http\Controllers\MultitvController;
use App\Http\Controllers\TipomusicaController;
use App\Http\Controllers\MusicaController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:api')->get('/user', function (Request $request) {
    return $request->user();
});

Route::apiResource('usuario', UsuarioController::class);
Route::apiResource('radio', RadioController::class);
Route::apiResource('programa', ProgramaController::class);
Route::apiResource('multiradio', MultiradioController::class);
Route::apiResource('video', VideoController::class);
Route::apiResource('podcast', PodcastController::class);
Route::apiResource('slide', SlideController::class);
Route::apiResource('equipo', EquipoController::class);
Route::apiResource('mensaje', MensajeController::class);
Route::apiResource('geovalla', GeovallaController::class);
Route::apiResource('multitv', MultitvController::class);
Route::apiResource('tipomusica', TipomusicaController::class);
Route::apiResource('musica', MusicaController::class);
Route::post('radio-update', [RadioController::class, 'updateRadio']);
Route::post('programa-update', [ProgramaController::class, 'updateProg']);
Route::post('multiradio-update', [MultiradioController::class, 'updateMulti']);
Route::post('multitv-update', [MultitvController::class, 'updateMultitv']);
Route::post('podcast-update', [PodcastController::class, 'updatePod']);
Route::post('slide-update', [SlideController::class, 'updateSlide']);
Route::post('equipo-update', [EquipoController::class, 'updateEquipo']);
Route::post('geovalla-update', [GeovallaController::class, 'updateGeovalla']);
Route::post('tipomusica-update', [TipomusicaController::class, 'updateTipomusica']);
Route::post('musica-update', [MusicaController::class, 'updateMusica']);
Route::get('radio-app/{id}', [RadioController::class, 'mostrarRadioUser']);
Route::get('programa-app/{id}', [ProgramaController::class, 'mostrarProgramaUser']);
Route::get('multiradio-app/{id}', [MultiradioController::class, 'mostrarMultiradioUser']);
Route::get('video-app/{id}', [VideoController::class, 'mostrarVideoUser']);
Route::get('podcast-app/{id}', [PodcastController::class, 'mostrarPodcastUser']);
Route::get('slide-app/{id}', [SlideController::class, 'mostrarSlidesUser']);
Route::get('equipo-app/{id}', [EquipoController::class, 'mostrarEquipoUser']);
Route::get('mensaje-app/{id}', [MensajeController::class, 'mostrarMensajeUser']);
Route::get('geovalla-app/{id}', [GeovallaController::class, 'mostrarGeovallaUser']);
Route::get('multitv-app/{id}', [MultitvController::class, 'mostrarMultiTvUser']);
Route::get('tipomusica-app/{id}', [TipomusicaController::class, 'mostrarTipomusicaUser']);
Route::get('musica-app/{id}', [MusicaController::class, 'mostrarMusicaUser']);
Route::post('login', [UsuarioController::class, 'login']);
Route::put('reset-password/{id}', [UsuarioController::class, 'resetPassword']);
Route::put('update-password/{id}', [UsuarioController::class, 'updatePassword']);
